/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.curseofpandora.content.sets.elemental;

import com.tterrag.registrate.util.entry.RegistryEntry;
import dev.xkmc.curseofpandora.content.complex.AttrAdder;
import dev.xkmc.curseofpandora.content.complex.BaseTickingToken;
import dev.xkmc.curseofpandora.content.complex.ITokenProviderItem;
import dev.xkmc.curseofpandora.event.ClientSpellText;
import dev.xkmc.curseofpandora.init.data.CoPConfig;
import dev.xkmc.curseofpandora.init.data.CoPLangData;
import dev.xkmc.curseofpandora.init.registrate.CoPAttrs;
import dev.xkmc.l2damagetracker.init.L2DamageTracker;
import dev.xkmc.l2serial.serialization.SerialClass;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class CurseRedirection
extends ITokenProviderItem<Data> {
    private static double getStat() {
        return (Double)CoPConfig.COMMON.elemental.curseRedirectionBonus.get();
    }

    private static int getIndexReq() {
        return (Integer)CoPConfig.COMMON.elemental.curseRedirectionRealityIndex.get();
    }

    private static AttrAdder magic(Player player) {
        int count = 0;
        for (EquipmentSlot e : EquipmentSlot.values()) {
            if (!e.m_254934_()) continue;
            ItemStack stack = player.m_6844_(e);
            for (Enchantment ent : stack.getAllEnchantments().keySet()) {
                if (!ent.m_6589_()) continue;
                ++count;
            }
        }
        double bonus = (double)count * CurseRedirection.getStat();
        return AttrAdder.of("curse_redirection", () -> ((RegistryEntry)L2DamageTracker.MAGIC_FACTOR).get(), AttributeModifier.Operation.ADDITION, () -> bonus);
    }

    private static AttrAdder spell(Player player) {
        int count = 0;
        block0: for (EquipmentSlot e : EquipmentSlot.values()) {
            if (!e.m_254934_()) continue;
            ItemStack stack = player.m_6844_(e);
            for (Enchantment ent : stack.getAllEnchantments().keySet()) {
                if (!ent.m_6589_()) continue;
                ++count;
                continue block0;
            }
        }
        double bonus = count;
        return AttrAdder.of("curse_redirection", CoPAttrs.SPELL, AttributeModifier.Operation.ADDITION, () -> bonus);
    }

    public CurseRedirection(Item.Properties properties) {
        super(properties, Data::new);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        boolean pass = ClientSpellText.getReality(level) >= CurseRedirection.getIndexReq();
        list.add((Component)CoPLangData.IDS.REALITY_INDEX.get(CurseRedirection.getIndexReq()).m_130940_(pass ? ChatFormatting.YELLOW : ChatFormatting.GRAY));
        list.add((Component)Component.m_237113_((String)"- ").m_7220_((Component)CoPLangData.Elemental.CURSE_1.get(new Object[0])).m_130940_(pass ? ChatFormatting.DARK_AQUA : ChatFormatting.DARK_GRAY));
        list.add((Component)Component.m_237113_((String)"- ").m_7220_((Component)CoPLangData.Elemental.CURSE_2.get(Math.round(CurseRedirection.getStat() * 100.0))).m_130940_(pass ? ChatFormatting.DARK_AQUA : ChatFormatting.DARK_GRAY));
    }

    @Override
    public void tick(Player player) {
        if (player.m_21133_((Attribute)CoPAttrs.REALITY.get()) >= (double)CurseRedirection.getIndexReq()) {
            super.tick(player);
        }
    }

    @SerialClass
    public static class Data
    extends BaseTickingToken {
        @Override
        protected void removeImpl(Player player) {
            CurseRedirection.magic(player).removeImpl(player);
            CurseRedirection.spell(player).removeImpl(player);
        }

        @Override
        protected void tickImpl(Player player) {
            if (player.m_9236_().m_5776_()) {
                return;
            }
            CurseRedirection.magic(player).tickImpl(player);
            CurseRedirection.spell(player).tickImpl(player);
        }
    }
}

